/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2024-02-06 14:29:28 +0000 (Tue, 06 Feb 2024) $ $Rev: 1787 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule;

import java.util.Date;
import java.util.List;

import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import de.consist.bmu.rule.impl.FXSDokument;
import de.consist.bmu.rule.schema.BMUMessageTypeImpl;
import de.consist.bmu.rule.schema.Namespace;

/**
 * Interface fuer den BMU-Nachrichtentyp, &lt;msg:Nachricht
 * xmlns:msg="uri:BMU_Waste_Interface/Message"/&gt;.
 */
@XmlJavaTypeAdapter(BMUMessageTypeImpl.Adapter.class)
public interface BMUMessageType {

    /**
     * @return BMUMessageTypeEnum
     */
    BMUMessageTypeEnum getEnumType();

    /**
     * @return Der target-ns des Dokuments
     */
    Namespace getNS();

    /**
     * @return Der XPath zum Ermitteln der fachlichen Nummer
     */
    String[] getXPathNummer();

    /**
     * @return Der BMU-Typ
     */
    String getBMUType();

    /**
     * @return true, wenn es sich um ein Layer-Dokument handelt
     */
    boolean isLayerDoc();

    /**
     * @return true, wenn es sich um ein Dokument vom Typ Nachricht handelt
     */
    boolean isMessage();

    /**
     * @return Die BMU-Version laut Attribut 'Spezifikationsversion', wobei der
     *         Punkt von '1.03' durch ein '_' ersetzt wird.
     */
    BMUVersion getVersion();

    /**
     * @return Die Msg-UUID
     */
    String getMsgUUID();

    /**
     * @return Der Name
     */
    String getName();

    /**
     * @return Die fachliche Nummer
     */
    String getDocNr();

    /**
     * @return Die Signatur-ID's
     */
    List<String> getSigIds();

    /**
     * @return Das Datum der aeltesten Signatur im Dokument
     */
    Date getFirstSignTime();

    /**
     * @return Das Datum der neuesten Signatur im Dokument
     */
    Date getLastSignTime();

    /**
     * Enumeration fuer den Status eines EN (EN, SN oder unbestimmt).
     */
    public enum ENStatus {
        /** EN. */
        EN,
        /** SN. */
        SN,
        /** Unbestimmt. */
        Unknown
    }

    /**
     * Liefert den Status (EN oder SN) eines ENSNDokuments in Abhngigkeit vom
     * IndicatorEN. Ist der Indikator nicht vorhanden, wird der Status Unknown
     * zurckgegeben. Fr alle anderen Dokumenttypen wird immer der Status
     * {@link BMUMessageType.ENStatus#Unknown Unknown} zurckgegeben.
     * 
     * @return den Status des ENSN
     */
    ENStatus getENStatus();

    /**
     * @return true, wenn es sich um eine interne ZKS-Nachricht
     *         (RegistrierungantragZKS, RegistrierungsauftragZKS) handelt, sonst
     *         false
     */
    boolean isIntern();

    /**
     * @return Liste der Signaturpruefungsergebnisse
     */
    List<SignatureVerificationResult> getSignatureVerificationResultList();

    /**
     * @param sigID
     *            Die Signature-ID
     * @return Das Pruefergebnis der Signatur
     */
    SignatureVerificationResult getSignatureVerificationResult(String sigID);

    /**
     * @return true, wenn das Dokument eingebettete Dokumente (EGF, AGS, DA)
     *         enthaelt, ansonsten false
     */
    boolean hasSubDocs();
    
    /**
     * 
     */
    List<FXSDokument> getFXSDokumentList();
}
