/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2024-02-06 14:29:28 +0000 (Tue, 06 Feb 2024) $ $Rev: 1787 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule.def;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;

/**
 * Adapter fuer die Konvertierung von Date nach xs:Date.
 */
public class XmlDateAdapter extends XmlAdapter<String, Date> {
    
    private DateFormat _df = new SimpleDateFormat("yyyy-MM-dd");
 
    /* (non-Javadoc)
     * @see jakarta.xml.bind.annotation.adapters.XmlAdapter#unmarshal(java.lang.Object)
     */
    @Override
    public final Date unmarshal(String date) throws Exception {
        return _df.parse(date);
    }
 
    /* (non-Javadoc)
     * @see jakarta.xml.bind.annotation.adapters.XmlAdapter#marshal(java.lang.Object)
     */
    @Override
    public final String marshal(Date date) throws Exception {
        return _df.format(date);
    }
}
