/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2019-05-09 14:25:04 +0000 (Thu, 09 May 2019) $ $Rev: 1592 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule.impl;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;

import javax.xml.xpath.XPathExpressionException;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.schema.Namespace;
import de.consist.bmu.rule.xpath.XPathFassade;

/**
 * @author srossbroich
 * 
 */
public final class RuleImplChecksumAttachment extends RuleImpl {

    private static final long serialVersionUID = 1L;

    private static final Log LOGGER = LogFactory.getLog(RuleImplChecksumAttachment.class);
    
    /**
     * XPath fuer lib:Pruefsumme.
     */
    private static final String XPATH_DATEIANHANG = "/descendant::*[local-name()='Dateianhang' and @lib:id]";

    private static final String TECHDOC = "Berechnet die Prfsumme eines Dateianhangs mit dem in 'lib:Fehlererkennung/lib:Methode' angegebenen Algporithmus "
            + "und vergleicht diese mit dem in 'lib:Fehlererkennung/lib:Pruefsumme' angegebenen Wert."
            + " Verwendeter XPath: " + XPATH_DATEIANHANG;
    /**
     * @param ruleDef
     *            RuleDef
     */
    public RuleImplChecksumAttachment(RuleDef ruleDef) {
        super(ruleDef);
    }

    /**
     * {@inheritDoc}
     */
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        List<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        NodeList nl;
        try {
            nl = XPathFassade.getInstance().evaluateNodeList(bmuDok.getDocument(),
                    XPATH_DATEIANHANG);
        } catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Prfen", e);
        }
        int index = 1;
        for (int i = 0; i < nl.getLength(); i++) {
            Node nodeDateianhang = nl.item(i);
            if (nodeDateianhang instanceof Element) {
                Element elemDateianhang = (Element) nodeDateianhang;
                String id = elemDateianhang.getAttributeNS(Namespace.TypenBibliothek.getUri(), "id");
                NodeList nodeListMethod = elemDateianhang.getElementsByTagNameNS(Namespace.TypenBibliothek.getUri(), "Methode");
                if (nodeListMethod.getLength() > 0) {
                    String algorithm = nodeListMethod.item(0).getTextContent();
                    try {
                        MessageDigest md = MessageDigest.getInstance(algorithm);
                        NodeList nodeListBinaerdaten = elemDateianhang.getElementsByTagNameNS(Namespace.TypenBibliothek.getUri(), "Binaerdaten");
                        if (nodeListBinaerdaten.getLength() > 0) {
                            String binaerDaten = nodeListBinaerdaten.item(0).getTextContent();
                            // Wenn es lib:Methode gibt muss es auch eine Pruefsumme geben..
                            String pruefsumme = elemDateianhang.getElementsByTagNameNS(Namespace.TypenBibliothek.getUri(), "Pruefsumme").item(0).getTextContent();
                            byte[] decodedBinaerdaten = Base64.decodeBase64(binaerDaten);
                            byte[] digestData = md.digest(decodedBinaerdaten);
                            String digest = Hex.encodeHexString(digestData);
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("given digest: " + pruefsumme);
                                LOGGER.debug("calulated digest: " + digest);
                            }
                            if (!pruefsumme.equalsIgnoreCase(digest)) {
                                ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++, id));
                            }
                        }
                    } catch (NoSuchAlgorithmException e) {
                        LOGGER.warn(e.getMessage());
                        ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++, id));
                    } catch (Exception e) {
                        LOGGER.error("Error decoding content of element 'Binaerdaten'", e);
                        ruleResultList.add(new RuleResultImpl(this.getRuleDef(), index++, id));
                    }
                }
            }
        }
        return ruleResultList;
    }

    /**
     * @return Die technische Dokumentation der Implementierung
     */
    public static String getTechDoc() {
        return TECHDOC;
    }

}
