/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2013-06-28 08:24:11 +0000 (Fri, 28 Jun 2013) $ $Rev: 1091 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule.impl;

import java.util.ArrayList;
import java.util.List;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.error.BMUException;

/**
 * Dokument muss eine Nachricht sein.
 * 
 * @author srossbroich
 * 
 */
public final class RuleImplSchemaNachricht extends RuleImpl {

    private static final long serialVersionUID = 1L;

    /**
     * @param ruleDef
     *            RuleDef
     */
    public RuleImplSchemaNachricht(RuleDef ruleDef) {
        super(ruleDef);
    }

    /**
     * {@inheritDoc}
     */
    public List<RuleResult> execute(BMUDokument bmuDok)
            throws BMUException {
        List<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        if (!bmuDok.getMessageType().isMessage()) {
            ruleResultList.add(new RuleResultImpl(this.getRuleDef(), 1, null));
        }
        return ruleResultList;
    }

    /**
     * @return Die technische Dokumentation der Implementierung
     */
    public static String getTechDoc() {
        return "Bei dem Wurzelelement des Dokumets muss es sich um 'msg:Nachricht' handeln.";
    }

}
