/**
 * BMUPruefBibliothek
 * $Author: srossbroich $ $Date: 2014-11-14 11:50:25 +0000 (Fri, 14 Nov 2014) $ $Rev: 1348 $
 * Copyright 2012 by Consist ITU Environmental Software GmbH
 */
package de.consist.bmu.rule.impl;

import java.util.ArrayList;
import java.util.List;

import javax.xml.xpath.XPathExpressionException;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import de.consist.bmu.rule.BMUDokument;
import de.consist.bmu.rule.RuleDef;
import de.consist.bmu.rule.RuleResult;
import de.consist.bmu.rule.SignatureVerificationResult;
import de.consist.bmu.rule.error.BMUException;
import de.consist.bmu.rule.xpath.XPathFassade;

/**
 * @author srossbroich
 * 
 */
public final class RuleImplSignatureXPath extends RuleImpl {

    private static final long serialVersionUID = 1L;

    /**
     * XPath fuer dsf:XPath.
     */
    private static final String XPATH_SIGXPATH = "/descendant::dsf:XPath[@Filter='intersect']";

    /**
     * @param ruleDef
     *            RuleDef
     */
    public RuleImplSignatureXPath(RuleDef ruleDef) {
        super(ruleDef);
    }

    /**
     * {@inheritDoc}
     */
    public List<RuleResult> execute(BMUDokument bmuDok) throws BMUException {
        List<RuleResult> ruleResultList = new ArrayList<RuleResult>();
        NodeList nl;
        try {
            nl = XPathFassade.getInstance().evaluateNodeList(
                    bmuDok.getDocument(), XPATH_SIGXPATH);
            int index = 1;
            for (int i = 0; i < nl.getLength(); i++) {
                Element xPathNode = (Element) nl.item(i);
                String sigID = XPathFassade.getInstance().evaluate(xPathNode, "ancestor::ds:Signature/@Id");
                SignatureVerificationResult svr = bmuDok.getMessageType()
                        .getSignatureVerificationResult(sigID);
                if (svr.isEnabled(getRuleDef())) {
	                String xPath = xPathNode.getTextContent();
	                // TODO Es wurde versprochen zu prfen, ob dies toleranter
	                // formuliert werden kann.
	                if (!xPath.startsWith("here()") && !xPath.contains("LayerID")) {
	                    ruleResultList.add(new RuleResultImpl(getRuleDef(), index++,
	                            sigID));
	                }
                }
            }
        } catch (XPathExpressionException e) {
            throw new BMUException("Fehler beim Prfen", e);
        }
        return ruleResultList;
    }

    /**
     * @return Die technische Dokumentation der Implementierung
     */
    public static String getTechDoc() {
        StringBuilder builder = new StringBuilder();
        builder.append("XPath fr die Ermittlung der zu prfenden Inhalte: ");
        builder.append(XPATH_SIGXPATH);
        builder.append(", die ermittelten XPath-Audrcke werden auf das Vorkommen von 'here()' bzw. 'LayerID' geprft. ");
        builder.append("Wenn beide Zeichenketten nicht gefunden werden, ist die Wahrscheinlichkeit gro, ");
        builder.append("dass es bei der Einbettung in andere BMU-Dokumente('ENSNDokument', 'Registerauszug') zu Problemen kommt.");
        return builder.toString();
    }

}
